
public class U6_3	{

    public static void main(String[] args) {
        byte b = 8;
        int i = 8;
        printBinary(b);
        printBinary(i);
    }

    /**
     * Prinzip am Beispiel byteValue = 8:
     * Der Wert 8 entspricht binr der 0000 1000.
     *
     * Nun werden die bits um 7 Positionen nach rechts geschoben
     * und mit der Zahl 1 (binr: 0000 0001) logisch "verUNDet".
     * Beim Shiften werden die "Lcken", die links entstehen
     * mit dem Vorzeichenbit (hier 0) aufgefllt:
     *
     * 0000 000|0|000 1000 (=8)
     * 0000 000|1|  (= 1)
     *
     * Durch die UND-Verknpfung mit der 1 erhlt man genau
     * den Wert an der markierten Stelle und kann diesen ausgeben lassen.
     *
     * Im nchsten Schritt verschiebt man die Bits um genau eine
     * Position weniger und erhlt so die zweite Stelle. Dies macht man
     * immer so weiter bis zur letzten Stelle.
     **/

    private static void printBinary(byte byteValue) {


        for (int i = 7; i >= 0; i--) {
            System.out.print((byteValue >> i) & 1);
        }

        System.out.println();
    }

    /**
     * Funktioniert analog zu printBinary(byte byteValue), nur dass
     * ein int-Wert 32 bit gro ist. Demnach muss der Wert zunchst
     * um 31 bits nach rechts verschoben werden...
     */

    private static void printBinary(int intValue) {
        for (int i = 31; i >= 0; i--) {
            System.out.print((intValue >> i) & 1);
        }

        System.out.println();
    }


}
