
public class U6_4 {

    public static void main(String[] args) {

        if (args.length == 0) {
            System.out.println("usage: java U6b_2 [-b byteValue] [-i intValue]");
            System.exit(1); // Programm beenden
        }


        for (int i=0;i<args.length;i++) {

            if (args[i].equals("-b")) {   // testen, ob nchster Parameter "-b" ist
                // byte-Wert folgt
                byte byteValue = Byte.parseByte(args[i+1]); // String in Byte umwandeln
                // da in args[i] bereits "-b" stand, steht die Zahl als String in args[i+1]
                // da mit dem String hier nicht gearbeitet werden kann, muss die Umwandlung
                // nach Byte zunchst erfolgen!

                i++;    // wichtig, da ja in der Zeile drber schon args[i+1] ausgelesen wurde!!

                System.out.println("(byte) "+byteValue+ " in Binrdarstellung:");
                printBinary(byteValue);  // Aufruf der Methode printBinary(byte byteValue)
                System.out.println(); // leere Zeile erzeugen
                continue; // durch das continue wird die Schleife nicht weiter ausgefhrt,
                          // sondern direkt neu gestartet (solange die Bedingung i<args.length
                          // erfllt ist). An dieser Stelle wird das continue bentigt, da wir
                          // nun ein Parameterpaar ("-b" und die darauf folgende Zahl) abgearbeitet
                          // haben und das Auswerten des nchsten Paares in einer neuen Schleife
                          // Sinn macht. Es knnte ja wieder ein "-b" beim Programmaufruf gefolgt sein.

            } // end if -b

            // an diese Stelle gelangt man nur, wenn der aktuelle Parameter nicht "-b" war

            if (args[i].equals("-i")) {
                // int-Wert folgt
                // analog zu oben

                int intValue = Integer.parseInt(args[i+1]); // String in int umwandeln
                i++;    // wichtig, da ja in der Zeile drber schon args[i+1] ausgelesen wurde!!
                System.out.println("(int) "+intValue+ " in Binrdarstellung:");
                printBinary(intValue);  // Aufruf der Methode printBinary(int intValue)
                System.out.println(); // leere Zeile erzeugen
                continue;

            } // end if -i



        }



    }

    /**
     * Prinzip am Beispiel byteValue = 8:
     * Der Wert 8 entspricht binr der 0000 1000.
     *
     * Nun werden die bits um 7 Positionen nach rechts geschoben
     * und mit der Zahl 1 (binr: 0000 0001) logisch "verUNDet".
     * Beim Shiften werden die "Lcken", die links entstehen
     * mit dem Vorzeichenbit (hier 0) aufgefllt:
     *
     * 0000 000|0|000 1000 (=8)
     * 0000 000|1|  (= 1)
     *
     * Durch die UND-Verknpfung mit der 1 erhlt man genau
     * den Wert an der markierten Stelle und kann diesen ausgeben lassen.
     *
     * Im nchsten Schritt verschiebt man die Bits um genau eine
     * Position weniger und erhlt so die zweite Stelle. Dies macht man
     * immer so weiter bis zur letzten Stelle.
     **/

    private static void printBinary(byte byteValue) {


        for (int i = 7; i >= 0; i--) {
            System.out.print((byteValue >> i) & 1);
        }

        System.out.println();
    }

    /**
     * Funktioniert analog zu printBinary(byte byteValue), nur dass
     * ein int-Wert 32 bit gro ist. Demnach muss der Wert zunchst
     * um 31 bits nach rechts verschoben werden...
     */

    private static void printBinary(int intValue) {
        for (int i = 31; i >= 0; i--) {
            System.out.print((intValue >> i) & 1);
        }

        System.out.println();
    }


}
