/***************************  BucketSort.java  ********************************/


/** Sortieren durch Verteilen auf Buckets (Eimer).
 *  Idee: 1.) Zaehlen der Hufigkeiten bucket[i] einzelner Schluessel i;
 *        2.) Buckets durchlaufen und i-ten Schluessel bucket[i]-mal ausgeben.
 *
 *  Nachteil von BucketSort: eingeschrnkter Wertebereich!
 */

public class BucketSort {

  static final int N = 256;                 // legt den Wertebereich fest
  											// hier: int-Zahlen zwischen 0 und 255

  public static int[] sort (int[] a) {      // sortiere int-Array a
                                            // und liefere Ergebnis zurueck
    
    int[] bucket = new int[N];              // N Buckets
	int[] result = new int[a.length];       // Ergebnisarray -> enthlt am Ende
										    // die sortierten Werte
    
	int cur_pos = 0;						// aktuelle Position im Ergebnisarray 
											// (am Anfang auf 0 gesetzt)

    for (int i=0; i < N; i++)  {
			bucket[i] = 0;    				// setze zunchst alle Buckets auf 0
    }

    for (int i=0; i < a.length; i++)  {     // fuer jedes Eingabezeichen
        bucket[a[i]]++;                     // zustndiges Bucket um eins erhoehen
											// bucket[a[i]]++ <=> bucket[a[i]]=bucket[a[i]]+1
    }
	
    for (int i=0; i < N; i++)  {            // fuer jedes Bucket
        for (int j=0; j < bucket[i]; j++) { // gemaess Zaehlerstand
            result[cur_pos++] =  i;         // sein Zeichen uebernehmen 
        }									// Beachten: cur_pos wird durch das ++ mit
    }										// jedem Durchlauf um eins erhht

    return result;                          // Ergebnisarray zurueckgeben
  }



  public static void main (String args[]) {
 
 	// unsortiertes Array mit Testwerten anlegen:
    int[] unsortiertes_array = new int[]  { 4,2,4,28,19,255,87,0,8,103 };  
	int[] ergebnis; // hier kommen spter die sortierten Werte rein                              
 	
	
	System.out.println("unsortiert: ");  
	
	for (int i=0;i<unsortiertes_array.length;i++) 
		System.out.print(unsortiertes_array[i] + "  ");
	System.out.println();
	
	
	// Bucket-Sort aufrufen:
	
    ergebnis = sort(unsortiertes_array); 
	
	// Ergebnis ausgeben
		                            
    
	System.out.println("sortiert mit Bucket-Sort: ");  
	
	for (int i=0;i<ergebnis.length;i++) 
		System.out.print(ergebnis[i] + "  ");
	System.out.println();	
	
  }
}


// Aufwand: O(n) + O(N)   bei n(=a.length) zu sortierenden Zeichen
//                        aus einem N-elementigen Alphabet
