public class Punkt {

    double x = 0; // X-Wert
    double y = 0; // Y-Wert

    // Konstruktor

    public Punkt(double x, double y) {
        this.x = x;
        this.y = y;
    }

    // Getter

    public double getX() {
        return x;
    }

    public double getY() {
        return y;
    }

    // Setter

    public void setX(double x) {
        this.x = x;
    }

    public void setY(double y) {
        this.y = y;
    }

    // Gleichheit

    public boolean equals(Punkt p) {
        return (this.getX() == p.getX()) && (this.getY() == p.getY());
    }

    // Ausgabe

    public void print() {
        System.out.println("("+this.getX()+"|"+this.getY()+")");
    }

    public void print(String s) {
        System.out.println(s+"("+this.getX()+"|"+this.getY()+")");
    }

    // Spiegelung

    public void mirrorX() {
        this.setY(-1*this.getY());
    }

    public void mirrorY() {
        this.setX(-1*this.getX());
    }

    // Distanz

    public double distanceTo(Punkt p) {
        return Math.sqrt( ( this.getX() - p.getX() ) * ( this.getX() - p.getX() ) +
                          ( this.getY() - p.getY() ) * ( this.getY() - p.getY() )
                        );
    }

    // Main Methode

    public static void main(String[] args) {

        // 3 neue Punkte erzeugen
        Punkt p1 = new Punkt(4.0, 2.0);   // Punkt (4|2)
        Punkt p2 = new Punkt(-3.0, 1.0);  // Punkt (-3|1)
        Punkt p3 = new Punkt(-4.0, -2.0);

        // die erzeugen Punkte ausgeben
        p1.print("P1: ");
        p2.print("P2: ");
        p3.print("P3: ");

        // p3 an der X-Achse spiegeln
        p3.mirrorX();
        // p3 an der Y-Achse spiegeln
        p3.mirrorY();

        // Gleichheit
        System.out.println("p1 == p2 : " + p1.equals(p2));
        System.out.println("p1 == p3 : " + p1.equals(p3));

        // Abstand berechnen
        System.out.println("Abstand p1-p2 : " + p1.distanceTo(p2));

    }
}
